/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.latvian.kubejs.ui.widget.Panorama;
import dev.latvian.kubejs.ui.widget.UI;
import dev.latvian.kubejs.ui.widget.Widget;
import dev.latvian.mods.kubejs.client.KubeJSClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class ScreenKubeJSUI
extends Screen {
    public final String screenId;
    public final Screen original;
    public final Consumer<UI> consumer;
    public final int forcedScale;
    public final UI ui;
    public final Map<ResourceLocation, Optional<EffectInstance>> shaders;

    public ScreenKubeJSUI(String i, Screen o, Consumer<UI> c, int fs) {
        super(o.m_96636_());
        this.screenId = i;
        this.original = o;
        this.consumer = c;
        this.forcedScale = fs;
        this.ui = new UI(this);
        this.shaders = new HashMap<ResourceLocation, Optional<EffectInstance>>();
    }

    public void m_7856_() {
        this.original.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        this.ui.hasShader = false;
        this.ui.children.clear();
        this.ui.allWidgets.clear();
        this.consumer.accept(this.ui);
        this.ui.collectWidgets(this.ui.allWidgets);
        for (Widget w : this.ui.allWidgets) {
            w.actualX = w.getX();
            w.actualY = w.getY();
        }
    }

    public Font getUiFont() {
        return this.f_96547_;
    }

    public boolean m_6913_() {
        return this.original.m_6913_() || this.screenId.startsWith("$");
    }

    public boolean m_7043_() {
        return this.original.m_7043_();
    }

    public void clearCaches() {
        for (Optional<EffectInstance> instance : this.shaders.values()) {
            try {
                instance.ifPresent(EffectInstance::close);
            }
            catch (Exception exception) {}
        }
        this.shaders.clear();
    }

    public void m_7861_() {
        this.clearCaches();
        super.m_7861_();
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.original.m_7333_(matrixStack);
        this.ui.mouse.x = mouseX;
        this.ui.mouse.y = mouseY;
        this.ui.time = System.currentTimeMillis() - UI.startTime;
        for (Widget w : this.ui.allWidgets) {
            boolean b = w.isMouseOver;
            boolean bl = w.isMouseOver = mouseX >= w.actualX && mouseY >= w.actualY && mouseX < w.actualX + w.getW() && mouseY < w.actualY + w.getH();
            if (b == w.isMouseOver) continue;
            if (w.isMouseOver) {
                if (w.mouseEnter == null) continue;
                w.mouseEnter.run();
                continue;
            }
            if (w.mouseExit == null) continue;
            w.mouseExit.run();
        }
        if (this.ui.screenRender != null) {
            this.ui.screenRender.accept(partialTicks);
        }
        this.ui.renderBackground(matrixStack, partialTicks);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.ui.renderForeground(matrixStack, partialTicks);
        ArrayList<Component> list = new ArrayList<Component>();
        this.ui.appendHoverText(list);
        if (!list.isEmpty()) {
            this.m_96597_(matrixStack, list, mouseX, mouseY);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.ui.mousePressed()) {
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.ui.mouseReleased();
        return super.m_6348_(x, y, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 294) {
            this.ui.tick = 0;
            if ((modifiers & 2) != 0) {
                KubeJSClient.reloadClientScripts();
                this.f_96541_.m_91152_((Screen)this);
            } else {
                UI.startTime = System.currentTimeMillis();
                this.ui.time = 0L;
                Panorama.panoramaTime = 0.0f;
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.ui.screenTick != null) {
            this.ui.screenTick.run();
        }
        ++this.ui.tick;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }
}

